-- MP3 ID Scanner
--  scans an mp3 file based on MP3v1
--  @todo: ID3v2 tags are work in progress
--[[
	THE BEER-WARE LICENSE (Revision 42):
	<der_ghulbus@ghulbus-inc.de> wrote this file. 
	As long as you retain this notice you can do whatever you want with this stuff. 
	If we meet some day, and you think this stuff is worth it, you can buy me a beer in return. 

	 Andreas Weis
  ]]
print("MP3 ID Scanner   - Mar 2007");

--Include libraries for parsing:
local inclib_v1 = loadfile(".\\id3_v1.lua");
local inclib_v2 = loadfile(".\\id3_v2.lua");

-- at the end of the program, the following table will hold all relevant information about the file:
mp3_file = {
	bitr = 0,
	freq = 0,
	mode = 0,
	mode_ext = 0,
	copyr = "",
	orig = "",
	emph = "",
	crcc = "",
	frame_size = 0,
	n_frames = 0,
	id3v1 = {
				Title = "",
				Artist = "",
				Album = "",
				Year = "",
				Comment = "",
				Genre = "",
			},
	id3v2 = {
				Title = "",
				Artist = "",
				Album = "",
				Year = "",
				Comment = "",
				Genre = "",
			},
};


--- PROGRAM ENTRY
local fname = ".\\test2.mp3";
print("Trying to open "..fname);
local f = assert(io.open(fname, "rb"));
local data = f:read("*all");	--Read the complete file (this really seems to be faster than reading the file directly to the table)
f:close();
local fsize = string.len(data);
print(" done.  ("..fsize.." bytes total)\n");

print("Checking file...");
--save the first 32 bits to a table for further processing:
local b = {};
for i=1, 4 do
	b[i] = string.byte(data,i);
end
-- check which file type is present:
if(b[1] == 255 and bit.band(b[2],0xE0) == 0xE0) then				--for ID3v1 the first 11 bits must all be set
	print(" File type is ID3v1.");
	inclib_v1();
	--load the remaining filesegments required for parsing (for id3v1: last 128 bytes of data)
	for i=1, 128 do
		b[4+i] = string.byte(data, fsize-128+i);
	end
elseif(b[1] == 0x49 and b[2] == 0x44 and b[3] == 0x33 ) then		--first three bytes must be "ID3" for ID3v2
	print(" File type is ID3v2.");
	inclib_v2();
	--load the remaining filesegments required for parsing:
	for i=5, 1024 do
		b[i] = string.byte(data, i);
	end
else
	print("ERROR: Invalid checksum!");
	return;
end
print(" done.\n");

mp3_file = parse_header(b, fsize);
 print("");
mp3_file.id3v1 = parse_id3v1(b);
 print("");
mp3_file.id3v2 = parse_id3v2(b);
 print("");
